/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.loaders;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import jdk.internal.loader.ClassLoaders;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import org.watermedia.WaterMedia;
import org.watermedia.core.exceptions.IllegalEnvironmentException;
import org.watermedia.core.exceptions.IllegalTLauncherException;
import org.watermedia.core.exceptions.IncompatibleModException;
import org.watermedia.core.tools.Tool;
import org.watermedia.loaders.ILoader;

@Mod(value="watermedia")
public class NeoFLoader
implements ILoader {
    private static final Path tmpPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");

    public NeoFLoader() {
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (this.ofcheck()) {
                throw new IncompatibleModException("optifine", "Optifine", "Embeddium (embeddium) or Sodium (sodium)");
            }
            if (this.clientSide()) {
                WaterMedia.prepare(this).start();
            } else if (!this.developerMode()) {
                throw new IllegalEnvironmentException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    public boolean ofcheck() {
        try {
            Class.forName("optifine.Installer", false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String name() {
        return "NeoForge";
    }

    @Override
    public Path tempDir() {
        return tmpPath;
    }

    @Override
    public Path processDir() {
        return FMLLoader.getGamePath();
    }

    @Override
    public boolean tlcheck() {
        Class<?> launcher2;
        boolean isT = Tool.t();
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            if (!isT) {
                launcher2 = Class.forName("cpw.mods.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher2.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher2) {
            // empty catch block
        }
        try {
            if (!isT) {
                launcher2 = Class.forName("net.minecraftforge.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher2.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher3) {
            // empty catch block
        }
        try {
            if (!isT) {
                launcher2 = Class.forName("cpw.mods.bootstraplauncher.BootstrapLauncher");
                Thread.currentThread().setContextClassLoader(launcher2.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher4) {
            // empty catch block
        }
        try {
            if (!isT) {
                launcher2 = Class.forName("net.minecraftforge.bootstraplauncher.BootstrapLauncher");
                Thread.currentThread().setContextClassLoader(launcher2.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher5) {
            // empty catch block
        }
        try {
            if (!isT) {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher5) {
            // empty catch block
        }
        try {
            if (!isT) {
                Thread.currentThread().setContextClassLoader(ClassLoaders.appClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (Throwable launcher5) {
            // empty catch block
        }
        try {
            if (!isT) {
                Collection<StackTraceElement[]> traceElements = Thread.getAllStackTraces().values();
                block14: for (StackTraceElement[] elements : traceElements) {
                    for (StackTraceElement e : elements) {
                        if (!e.getClassName().startsWith("org.tlauncher")) continue;
                        isT = true;
                        continue block14;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isT;
    }

    @Override
    public boolean clientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public boolean developerMode() {
        return !FMLLoader.isProduction();
    }
}

