/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.setup;

import com.refinedmods.refinedstorage.RSBlockEntities;
import com.refinedmods.refinedstorage.RSContainerMenus;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.container.CrafterContainerMenu;
import com.refinedmods.refinedstorage.container.CrafterManagerContainerMenu;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.item.property.ControllerItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.NetworkItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.SecurityCardItemPropertyGetter;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.blockentity.StorageMonitorBlockEntityRenderer;
import com.refinedmods.refinedstorage.render.color.PatternItemColor;
import com.refinedmods.refinedstorage.render.model.DiskDriveGeometryLoader;
import com.refinedmods.refinedstorage.render.model.DiskManipulatorGeometryLoader;
import com.refinedmods.refinedstorage.render.model.PortableGridGeometryLoader;
import com.refinedmods.refinedstorage.render.model.baked.CableCoverBakedModel;
import com.refinedmods.refinedstorage.render.model.baked.CableCoverItemBakedModel;
import com.refinedmods.refinedstorage.render.model.baked.PatternBakedModel;
import com.refinedmods.refinedstorage.render.resourcepack.ResourcePackListener;
import com.refinedmods.refinedstorage.screen.ConstructorScreen;
import com.refinedmods.refinedstorage.screen.ControllerScreen;
import com.refinedmods.refinedstorage.screen.CrafterScreen;
import com.refinedmods.refinedstorage.screen.CraftingMonitorScreen;
import com.refinedmods.refinedstorage.screen.DestructorScreen;
import com.refinedmods.refinedstorage.screen.DetectorScreen;
import com.refinedmods.refinedstorage.screen.DiskDriveScreen;
import com.refinedmods.refinedstorage.screen.DiskManipulatorScreen;
import com.refinedmods.refinedstorage.screen.ExporterScreen;
import com.refinedmods.refinedstorage.screen.ExternalStorageScreen;
import com.refinedmods.refinedstorage.screen.FilterScreen;
import com.refinedmods.refinedstorage.screen.FluidInterfaceScreen;
import com.refinedmods.refinedstorage.screen.FluidStorageBlockScreen;
import com.refinedmods.refinedstorage.screen.ImporterScreen;
import com.refinedmods.refinedstorage.screen.InterfaceScreen;
import com.refinedmods.refinedstorage.screen.KeyInputListener;
import com.refinedmods.refinedstorage.screen.NetworkTransmitterScreen;
import com.refinedmods.refinedstorage.screen.RelayScreen;
import com.refinedmods.refinedstorage.screen.SecurityManagerScreen;
import com.refinedmods.refinedstorage.screen.StorageBlockScreen;
import com.refinedmods.refinedstorage.screen.StorageMonitorScreen;
import com.refinedmods.refinedstorage.screen.WirelessTransmitterScreen;
import com.refinedmods.refinedstorage.screen.factory.CrafterManagerScreenFactory;
import com.refinedmods.refinedstorage.screen.factory.GridScreenFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ClientSetup {
    private static final ResourceLocation DISK_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk");
    private static final ResourceLocation DISK_NEAR_CAPACITY_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_near_capacity");
    private static final ResourceLocation DISK_FULL_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_full");
    private static final ResourceLocation DISK_DISCONNECTED_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_disconnected");
    private static final ResourceLocation CONNECTED = new ResourceLocation("refinedstorage", "connected");
    private static final BakedModelOverrideRegistry BAKED_MODEL_OVERRIDE_REGISTRY = new BakedModelOverrideRegistry();

    private ClientSetup() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputListener());
        ClientSetup.registerBakedModelOverrides();
        ClientSetup.registerPatternRenderHandlers();
        e.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.FILTER.get()), FilterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.CONTROLLER.get()), ControllerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.DISK_DRIVE.get()), DiskDriveScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.GRID.get()), (MenuScreens.ScreenConstructor)new GridScreenFactory());
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.STORAGE_BLOCK.get()), StorageBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.FLUID_STORAGE_BLOCK.get()), FluidStorageBlockScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.EXTERNAL_STORAGE.get()), ExternalStorageScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.IMPORTER.get()), ImporterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.EXPORTER.get()), ExporterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.NETWORK_TRANSMITTER.get()), NetworkTransmitterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.RELAY.get()), RelayScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.DETECTOR.get()), DetectorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.SECURITY_MANAGER.get()), SecurityManagerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.INTERFACE.get()), InterfaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.FLUID_INTERFACE.get()), FluidInterfaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.WIRELESS_TRANSMITTER.get()), WirelessTransmitterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.STORAGE_MONITOR.get()), StorageMonitorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.CONSTRUCTOR.get()), ConstructorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.DESTRUCTOR.get()), DestructorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.DISK_MANIPULATOR.get()), DiskManipulatorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.CRAFTER.get()), CrafterScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.CRAFTER_MANAGER.get()), (MenuScreens.ScreenConstructor)new CrafterManagerScreenFactory());
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.CRAFTING_MONITOR.get()), CraftingMonitorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)RSContainerMenus.WIRELESS_CRAFTING_MONITOR.get()), CraftingMonitorScreen::new);
        });
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)RSBlockEntities.STORAGE_MONITOR.get()), ctx -> new StorageMonitorBlockEntityRenderer());
        e.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)RSItems.SECURITY_CARD.get()), (ResourceLocation)new ResourceLocation("refinedstorage", "active"), (ItemPropertyFunction)new SecurityCardItemPropertyGetter());
            RSItems.CONTROLLER.values().forEach(controller -> ItemProperties.register((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("refinedstorage", "energy_type"), (ItemPropertyFunction)new ControllerItemPropertyGetter()));
            RSItems.CREATIVE_CONTROLLER.values().forEach(controller -> ItemProperties.register((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("refinedstorage", "energy_type"), (ItemPropertyFunction)new ControllerItemPropertyGetter()));
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
            ItemProperties.register((Item)((Item)RSItems.CREATIVE_WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (ItemPropertyFunction)new NetworkItemPropertyGetter());
        });
    }

    private static void registerPatternRenderHandlers() {
        API.instance().addPatternRenderHandler(pattern -> Screen.m_96638_());
        API.instance().addPatternRenderHandler(pattern -> {
            AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
            if (container instanceof CrafterManagerContainerMenu) {
                for (Slot slot : container.f_38839_) {
                    if (!(slot instanceof CrafterManagerSlot) || slot.m_7993_() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
        API.instance().addPatternRenderHandler(pattern -> {
            AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
            if (container instanceof CrafterContainerMenu) {
                for (int i = 0; i < 9; ++i) {
                    if (container.m_38853_(i).m_7993_() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static void registerBakedModelOverrides() {
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "cable"), (base, registry) -> new CableCoverBakedModel(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "exporter"), (base, registry) -> new CableCoverBakedModel(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "importer"), (base, registry) -> new CableCoverBakedModel(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "external_storage"), (base, registry) -> new CableCoverBakedModel(base));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "cover"), (base, registry) -> new CableCoverItemBakedModel(ItemStack.f_41583_, CoverType.NORMAL));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "hollow_cover"), (base, registry) -> new CableCoverItemBakedModel(ItemStack.f_41583_, CoverType.HOLLOW));
        BAKED_MODEL_OVERRIDE_REGISTRY.add(new ResourceLocation("refinedstorage", "pattern"), (base, registry) -> new PatternBakedModel(base));
    }

    @SubscribeEvent
    public static void onRegisterColorBindings(RegisterColorHandlersEvent.Item e) {
        e.register((ItemColor)new PatternItemColor(), new ItemLike[]{(ItemLike)RSItems.PATTERN.get()});
    }

    @SubscribeEvent
    public static void onRegisterKeymappings(RegisterKeyMappingsEvent e) {
        e.register(RSKeyBindings.FOCUS_SEARCH_BAR);
        e.register(RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX);
        e.register(RSKeyBindings.OPEN_WIRELESS_GRID);
        e.register(RSKeyBindings.OPEN_WIRELESS_FLUID_GRID);
        e.register(RSKeyBindings.OPEN_WIRELESS_CRAFTING_MONITOR);
        e.register(RSKeyBindings.OPEN_PORTABLE_GRID);
    }

    @SubscribeEvent
    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ResourcePackListener());
    }

    @SubscribeEvent
    public static void onRegisterAdditionalModels(ModelEvent.RegisterAdditional e) {
        e.register(DISK_RESOURCE);
        e.register(DISK_NEAR_CAPACITY_RESOURCE);
        e.register(DISK_FULL_RESOURCE);
        e.register(DISK_DISCONNECTED_RESOURCE);
        e.register(new ResourceLocation("refinedstorage:block/disk_manipulator/disconnected"));
        for (DyeColor color : DyeColor.values()) {
            e.register(new ResourceLocation("refinedstorage:block/disk_manipulator/" + color));
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult e) {
        for (ResourceLocation id : e.getModels().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = BAKED_MODEL_OVERRIDE_REGISTRY.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModels().put(id, factory.create((BakedModel)e.getModels().get(id), e.getModels()));
        }
    }

    @SubscribeEvent
    public static void onRegisterModelGeometry(ModelEvent.RegisterGeometryLoaders e) {
        e.register("disk_drive", (IGeometryLoader)new DiskDriveGeometryLoader());
        e.register("disk_manipulator", (IGeometryLoader)new DiskManipulatorGeometryLoader());
        e.register("portable_grid", (IGeometryLoader)new PortableGridGeometryLoader());
    }
}

