/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.factory.PortableGridGridFactory;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.NetworkItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class OpenNetworkItemMessage {
    private final PlayerSlot slot;

    public OpenNetworkItemMessage(PlayerSlot slot) {
        this.slot = slot;
    }

    public static OpenNetworkItemMessage decode(FriendlyByteBuf buf) {
        return new OpenNetworkItemMessage(new PlayerSlot(buf));
    }

    public static void encode(OpenNetworkItemMessage message, FriendlyByteBuf buf) {
        message.slot.writePlayerSlot(buf);
    }

    public static void handle(OpenNetworkItemMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack = message.slot.getStackFromSlot((Player)player);
                if (stack == null) {
                    return;
                }
                if (stack.m_41720_() instanceof NetworkItem) {
                    ((NetworkItem)stack.m_41720_()).applyNetwork(player.m_20194_(), stack, n -> n.getNetworkItemManager().open((Player)player, stack, message.slot), arg_0 -> ((ServerPlayer)player).m_213846_(arg_0));
                } else if (stack.m_41720_() instanceof PortableGridBlockItem) {
                    API.instance().getGridManager().openGrid(PortableGridGridFactory.ID, player, stack, message.slot);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

