/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.CraftingMonitorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.container.BaseContainerMenu;
import com.refinedmods.refinedstorage.network.craftingmonitor.CraftingMonitorUpdateMessage;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftingMonitorContainerMenu
extends BaseContainerMenu
implements ICraftingMonitorListener {
    private final ICraftingMonitor craftingMonitor;
    private boolean addedListener;

    public CraftingMonitorContainerMenu(MenuType<CraftingMonitorContainerMenu> type, ICraftingMonitor craftingMonitor, @Nullable CraftingMonitorBlockEntity blockEntity, Player player, int windowId) {
        super(type, blockEntity, player, windowId);
        this.craftingMonitor = craftingMonitor;
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (!this.getPlayer().m_9236_().f_46443_) {
            ICraftingManager manager = this.craftingMonitor.getCraftingManager();
            if (manager != null && !this.addedListener) {
                manager.addListener(this);
                this.addedListener = true;
            } else if (manager == null && this.addedListener) {
                this.addedListener = false;
            }
        }
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_20193_().f_46443_) {
            this.craftingMonitor.onClosed(player);
            ICraftingManager manager = this.craftingMonitor.getCraftingManager();
            if (manager != null && this.addedListener) {
                manager.removeListener(this);
            }
        }
    }

    public ICraftingMonitor getCraftingMonitor() {
        return this.craftingMonitor;
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            stack = slot.m_7993_();
            if (index < 4 ? !this.m_38903_(stack, 4, this.f_38839_.size(), false) : !this.m_38903_(stack, 0, 4, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    @Override
    protected int getDisabledSlotNumber() {
        return this.craftingMonitor.getSlotId();
    }

    @Override
    public void onAttached() {
        this.onChanged();
    }

    @Override
    public void onChanged() {
        RS.NETWORK_HANDLER.sendTo((ServerPlayer)this.getPlayer(), new CraftingMonitorUpdateMessage(this.craftingMonitor));
    }
}

