/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingRequestInfo
implements ICraftingRequestInfo {
    private static final String NBT_FLUID = "Fluid";
    private static final String NBT_STACK = "Stack";
    private ItemStack item;
    private FluidStack fluid;

    public CraftingRequestInfo(CompoundTag tag) throws CraftingTaskReadException {
        if (!tag.m_128471_(NBT_FLUID)) {
            this.item = StackUtils.deserializeStackFromNbt(tag.m_128469_(NBT_STACK));
            if (this.item.m_41619_()) {
                throw new CraftingTaskReadException("Extractor stack is empty");
            }
        } else {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(NBT_STACK));
            if (this.fluid.isEmpty()) {
                throw new CraftingTaskReadException("Extractor fluid stack is empty");
            }
        }
    }

    public CraftingRequestInfo(ItemStack item) {
        this.item = item;
    }

    public CraftingRequestInfo(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    @Nullable
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(NBT_FLUID, this.fluid != null);
        if (this.fluid != null) {
            tag.m_128365_(NBT_STACK, (Tag)this.fluid.writeToNBT(new CompoundTag()));
        } else {
            tag.m_128365_(NBT_STACK, (Tag)StackUtils.serializeStackToNbt(this.item));
        }
        return tag;
    }
}

