/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.content.switches.forge.TrackSwitchBlockImpl;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.block.IBE;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrackSwitchBlock
extends HorizontalDirectionalBlock
implements IBE<TrackSwitchBlockEntity>,
IWrenchable {
    boolean isAutomatic;
    public static final BooleanProperty LOCKED = BlockStateProperties.f_61444_;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TrackSwitchBlock manual(BlockBehaviour.Properties properties) {
        return TrackSwitchBlockImpl.manual(properties);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TrackSwitchBlock automatic(BlockBehaviour.Properties properties) {
        return TrackSwitchBlockImpl.automatic(properties);
    }

    protected TrackSwitchBlock(BlockBehaviour.Properties properties, boolean isAutomatic) {
        super(properties);
        this.isAutomatic = isAutomatic;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{LOCKED}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(context.m_43725_().m_276987_(context.m_8083_().m_7495_(), Direction.DOWN)));
    }

    public Class<TrackSwitchBlockEntity> getBlockEntityClass() {
        return TrackSwitchBlockEntity.class;
    }

    public BlockEntityType<? extends TrackSwitchBlockEntity> getBlockEntityType() {
        return this.isAutomatic ? (BlockEntityType)CRBlockEntities.BRASS_SWITCH.get() : (BlockEntityType)CRBlockEntities.ANDESITE_SWITCH.get();
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityContext;
        if (context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).m_193113_() instanceof Projectile) {
            return this.isAutomatic ? CRShapes.BRASS_SWITCH_PROJECTILE.get((Direction)state.m_61143_((Property)f_54117_)) : CRShapes.ANDESITE_SWITCH_PROJECTILE.get((Direction)state.m_61143_((Property)f_54117_));
        }
        return this.isAutomatic ? CRShapes.BRASS_SWITCH.get((Direction)state.m_61143_((Property)f_54117_)) : CRShapes.ANDESITE_SWITCH.get((Direction)state.m_61143_((Property)f_54117_));
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.f_60443_ ? this.m_5940_(state, level, pos, context) : Shapes.m_83040_();
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (AllItems.WRENCH.isIn(itemInHand)) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            if (player.m_36316_() == ConductorEntity.FAKE_PLAYER_PROFILE) {
                return te.onProjectileHit() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
            }
            return te.onUse(player.m_20161_());
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.m_5581_(level, state, hit, projectile);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, hit.m_82425_());
        if (te != null) {
            te.onProjectileHit();
        }
        if (projectile instanceof Arrow) {
            projectile.m_146870_();
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            te.checkRedstoneInputs();
        }
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TrackSwitchBlockEntity) {
            TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)blockEntity;
            return te.getTargetAnalogOutput();
        }
        return 0;
    }

    public static enum SwitchState implements StringRepresentable
    {
        NORMAL(0),
        REVERSE_LEFT(-1),
        REVERSE_RIGHT(1);

        private final int direction;

        private SwitchState(int direction) {
            this.direction = direction;
        }

        public static SwitchState fromSteerDirection(TravellingPoint.SteerDirection direction, boolean forward) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case TravellingPoint.SteerDirection.NONE -> NORMAL;
                case TravellingPoint.SteerDirection.LEFT -> {
                    if (forward) {
                        yield REVERSE_LEFT;
                    }
                    yield REVERSE_RIGHT;
                }
                case TravellingPoint.SteerDirection.RIGHT -> forward ? REVERSE_RIGHT : REVERSE_LEFT;
            };
        }

        @NotNull
        public String m_7912_() {
            return Lang.asId((String)this.name());
        }

        public boolean canSwitchTo(SwitchState next, SwitchConstraint constraint) {
            return switch (constraint) {
                default -> throw new IncompatibleClassChangeError();
                case SwitchConstraint.NONE -> true;
                case SwitchConstraint.TO_LEFT -> {
                    if (next.direction <= this.direction) {
                        yield true;
                    }
                    yield false;
                }
                case SwitchConstraint.TO_RIGHT -> next.direction >= this.direction;
            };
        }

        @NotNull
        public SwitchState nextStateFor(TrackSwitch sw, SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (sw.hasLeftExit() && constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                } else {
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                }
            } else if (this == REVERSE_LEFT) {
                if (sw.hasStraightExit() && constraint.canGoRight()) {
                    return NORMAL;
                }
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
            }
            return this;
        }

        public SwitchState nextStateForPonder(SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                } else if (constraint.canGoLeft()) {
                    return NORMAL;
                }
            } else if (this == REVERSE_LEFT && constraint.canGoRight()) {
                return NORMAL;
            }
            return this;
        }
    }

    public static enum SwitchConstraint {
        NONE,
        TO_RIGHT,
        TO_LEFT;


        public boolean canGoRight() {
            return this != TO_LEFT;
        }

        public boolean canGoLeft() {
            return this != TO_RIGHT;
        }
    }
}

