/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.content.smokestack.SmokestackStyle;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractSmokeStackBlock<T extends SmartBlockEntity>
extends Block
implements ProperWaterloggedBlock,
IWrenchable,
IBE<T> {
    public static final EnumProperty<SmokestackStyle> STYLE = EnumProperty.m_61587_((String)"style", SmokestackStyle.class);
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final ShapeWrapper shape;
    final String variant;

    public AbstractSmokeStackBlock(BlockBehaviour.Properties properties, ShapeWrapper shape, String variant) {
        super(properties);
        this.m_49959_(this.makeDefaultState());
        this.shape = shape;
        this.variant = variant;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape.get();
    }

    protected BlockState makeDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(STYLE, (Comparable)((Object)SmokestackStyle.STEEL))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STYLE}).m_61104_(new Property[]{ENABLED}).m_61104_(new Property[]{POWERED}).m_61104_(new Property[]{WATERLOGGED});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        if (this.variant.equals("diesel") || this.variant.equals("caboosestyle")) {
            return super.m_7397_(level, pos, state);
        }
        return CRBlocks.SMOKESTACK_GROUP.get(this.variant).get((SmokestackStyle)((Object)state.m_61143_(STYLE))).asStack();
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        blockstate = (BlockState)blockstate.m_61124_(STYLE, (Comparable)((Object)SmokestackStyle.STEEL));
        if (context.m_43725_().m_276867_(context.m_8083_())) {
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (AllTags.AllItemTags.WRENCH.matches(pPlayer.m_21120_(pHand))) {
            return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        pState = (BlockState)pState.m_61122_((Property)ENABLED);
        pLevel.m_7731_(pPos, pState, 2);
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_) {
            boolean shouldBeEnabled;
            boolean powered = level.m_276867_(pos);
            boolean bl = shouldBeEnabled = !powered;
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                if ((Boolean)state.m_61143_((Property)ENABLED) != shouldBeEnabled) {
                    state = (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(shouldBeEnabled));
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                    level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
                }
            }
        }
    }

    public Item m_5456_() {
        return super.m_5456_();
    }
}

