/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.gui.frame.components;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.embeddedt.embeddium.gui.frame.components.SearchTextFieldModel;
import org.jetbrains.annotations.Nullable;

public class SearchTextFieldComponent
extends AbstractWidget {
    protected final Dim2i dim;
    protected final List<OptionPage> pages;
    private final Font textRenderer;
    private final BiFunction<String, Integer, FormattedCharSequence> renderTextProvider;
    private final SearchTextFieldModel model;

    public SearchTextFieldComponent(Dim2i dim, List<OptionPage> pages, SearchTextFieldModel model) {
        this.textRenderer = Minecraft.m_91087_().f_91062_;
        this.renderTextProvider = (string, firstCharacterIndex) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);
        this.dim = dim;
        this.pages = pages;
        this.model = model;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.model.innerWidth = this.getInnerWidth();
        if (!this.isVisible()) {
            return;
        }
        if (this.model.text.isEmpty()) {
            this.drawString(context, (Component)Component.m_237115_((String)"embeddium.search_bar_empty"), this.dim.x() + 6, this.dim.y() + 6, -5592406);
        }
        this.drawRect(context, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), this.m_93696_() ? -536870912 : -1879048192);
        int j = this.model.selectionStart - this.model.firstCharacterIndex;
        int k = this.model.selectionEnd - this.model.firstCharacterIndex;
        String string = this.textRenderer.m_92834_(this.model.text.substring(this.model.firstCharacterIndex), this.getInnerWidth());
        boolean bl = j >= 0 && j <= string.length();
        int l = this.dim.x() + 6;
        int m = this.dim.y() + 6;
        int n = l;
        if (k > string.length()) {
            k = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, j) : string;
            n = context.m_280648_(this.textRenderer, this.renderTextProvider.apply(string2, this.model.firstCharacterIndex), n, m, -1);
        }
        boolean bl3 = this.model.selectionStart < this.model.text.length() || this.model.text.length() >= this.model.getMaxLength();
        int o = n;
        if (!bl) {
            o = j > 0 ? l + this.dim.width() - 12 : l;
        } else if (bl3) {
            --o;
            --n;
        }
        if (!string.isEmpty() && bl && j < string.length()) {
            context.m_280648_(this.textRenderer, this.renderTextProvider.apply(string.substring(j), this.model.selectionStart), n, m, -1);
        }
        if (this.m_93696_()) {
            RenderType renderType = RenderType.m_286086_();
            Objects.requireNonNull(this.textRenderer);
            context.m_285944_(renderType, o, m - 1, o + 1, m + 1 + 9, -3092272);
        }
        if (k != j) {
            int p = l + this.textRenderer.m_92895_(string.substring(0, k));
            Objects.requireNonNull(this.textRenderer);
            this.drawSelectionHighlight(context, o, m - 1, p - 1, m + 1 + 9);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int i = Mth.m_14107_((double)mouseX) - this.dim.x() - 6;
        String string = this.textRenderer.m_92834_(this.model.text.substring(this.model.firstCharacterIndex), this.getInnerWidth());
        this.model.setCursor(this.textRenderer.m_92834_(string, i).length() + this.model.firstCharacterIndex);
        this.m_93692_(this.dim.containsCursor(mouseX, mouseY));
        return this.m_93696_();
    }

    @Override
    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    private void drawSelectionHighlight(GuiGraphics context, int x1, int y1, int x2, int y2) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > this.dim.x() + this.dim.width()) {
            x2 = this.dim.x() + this.dim.width();
        }
        if (x1 > this.dim.x() + this.dim.width()) {
            x1 = this.dim.x() + this.dim.width();
        }
        context.m_285944_(RenderType.m_285783_(), x1, y1, x2, y2, -16776961);
    }

    public boolean m_142518_() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (!this.m_142518_()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            if (this.model.editable) {
                this.model.write(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_142518_()) {
            return false;
        }
        this.model.selecting = Screen.m_96638_();
        if (Screen.m_96634_((int)keyCode)) {
            this.model.setCursorToEnd();
            this.model.setSelectionEnd(0);
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.model.getSelectedText());
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.model.editable) {
                this.model.write(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.model.getSelectedText());
            if (this.model.editable) {
                this.model.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.model.editable) {
                    this.model.selecting = false;
                    this.model.erase(-1);
                    this.model.selecting = Screen.m_96638_();
                }
                return true;
            }
            case 261: {
                if (this.model.editable) {
                    this.model.selecting = false;
                    this.model.erase(1);
                    this.model.selecting = Screen.m_96638_();
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.model.setCursor(this.model.getWordSkipPosition(1));
                } else {
                    this.model.moveCursor(1);
                }
                boolean state = this.model.getCursor() != this.model.lastCursorPosition && this.model.getCursor() != this.model.text.length() + 1;
                this.model.lastCursorPosition = this.model.getCursor();
                return state;
            }
            case 263: {
                if (Screen.m_96637_()) {
                    this.model.setCursor(this.model.getWordSkipPosition(-1));
                } else {
                    this.model.moveCursor(-1);
                }
                boolean state = this.model.getCursor() != this.model.lastCursorPosition && this.model.getCursor() != 0;
                this.model.lastCursorPosition = this.model.getCursor();
                return state;
            }
            case 268: {
                this.model.setCursorToStart();
                return true;
            }
            case 269: {
                this.model.setCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.model.visible;
    }

    public boolean isEditable() {
        return this.model.editable;
    }

    public int getInnerWidth() {
        return this.dim.width() - 12;
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent navigation) {
        if (!this.model.visible) {
            return null;
        }
        return super.m_264064_(navigation);
    }

    public ScreenRectangle m_264198_() {
        return new ScreenRectangle(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }
}

